IF OBJECT_ID('P_EST_PROD_CPL_CALCULA_QTDE_DIAS_SLD_QT_EST') IS NOT NULL
	BEGIN
		DROP PROCEDURE P_EST_PROD_CPL_CALCULA_QTDE_DIAS_SLD_QT_EST
	END
GO


-- P_EST_PROD_CPL_CALCULA_QTDE_DIAS_SLD_QT_EST 1, 999,'20150401'
--DECLARE @CD INT = (SELECT TOP 1 CD_FILIAL FROM V_PRC_FILIAL_RELACAO_DEPOSITOS)
--EXEC P_EST_PROD_CPL_CALCULA_QTDE_DIAS_SLD_QT_EST 1, @CD 

CREATE PROCEDURE P_EST_PROD_CPL_CALCULA_QTDE_DIAS_SLD_QT_EST (@CD_EMP INT, @CD_FILIAL INT, @DT_REF DATETIME=NULL)
AS
 --DECLARE @CD_EMP INT=1, @CD_FILIAL INT=999, @DT_REF DATETIME='20150601'
/*******************************************************************************/
BEGIN TRY 
	DROP TABLE #ULT_ENT 
	END TRY BEGIN CATCH END CATCH
BEGIN TRY 
	DROP TABLE #RS_ULT_ZERO 
	END TRY BEGIN CATCH END CATCH

CREATE TABLE #ULT_ENT (CD_FILIAL INT, CD_PROD INT, DT_EST DATETIME, QT_DIAS INT)
CREATE TABLE #RS_ULT_ZERO (CD_FILIAL INT, CD_PROD INT, DT_EST_ZERO DATETIME)


IF @DT_REF IS NULL
	GOTO SaldoDiario

/*******************************************************************************/
--BUSCA ULTIMA DATA QUE O PRODUTO ZEROU
/*******************************************************************************/
	
	INSERT INTO #RS_ULT_ZERO
	SELECT 
		CD_FILIAL,
		CD_PROD,
		MAX(DT_VD) DT_EST_ZERO
	FROM 
		EST_PROD_CPL_ANALISE_DIARIO
	WHERE
		CD_EMP=@CD_EMP
		AND CD_FILIAL=@CD_FILIAL
		AND DT_VD > @DT_REF
		AND QT_EST<=0
	GROUP BY CD_FILIAL,CD_PROD;
 
/*******************************************************************************/
--INSERE A PARTIR DA ULTIMA DATA QUE O PRODUTO ZEROU
/*******************************************************************************/

	INSERT INTO #ULT_ENT (CD_FILIAL,CD_PROD,DT_EST,QT_DIAS)
	SELECT 
		A.CD_FILIAL,
		A.CD_PROD,
		MIN(DT_VD) DT_EST,
		0
	FROM 
		EST_PROD_CPL_ANALISE_DIARIO A
		INNER JOIN #RS_ULT_ZERO U ON 
		A.CD_PROD = U.CD_PROD AND
		A.CD_FILIAL = U.CD_FILIAL AND
		A.DT_VD > U.DT_EST_ZERO
	WHERE
		A.CD_EMP=@CD_EMP
		AND A.CD_FILIAL=@CD_FILIAL
		AND A.DT_VD > @DT_REF
		AND A.QT_EST>0 
	GROUP BY 
		A.CD_FILIAL,
		A.CD_PROD;

/*******************************************************************************/
--INSERE A PARTIR DA MENOR DATA DE ESTOQUE
/*******************************************************************************/

INSERT INTO #ULT_ENT (CD_FILIAL,CD_PROD,DT_EST,QT_DIAS)
SELECT 
	A.CD_FILIAL,A.CD_PROD,
	MIN(DT_VD) DT_EST,0
FROM 
	EST_PROD_CPL_ANALISE_DIARIO A
	LEFT JOIN #ULT_ENT U ON 
	A.CD_PROD = U.CD_PROD  
WHERE
	A.CD_EMP=@CD_EMP
	AND A.CD_FILIAL=@CD_FILIAL
	AND U.CD_PROD IS NULL
	AND A.DT_VD > @DT_REF
	AND A.QT_EST>0 
GROUP BY A.CD_FILIAL,A.CD_PROD


/*******************************************************************************/
--Calcula os dias
/*******************************************************************************/

	UPDATE	#ULT_ENT
	SET QT_DIAS	= DATEDIFF(DAY,DT_EST,GETDATE())


/*******************************************************************************/
--Atualiza EST_PROD_CPL
/*******************************************************************************/

SaldoDiario:
IF @DT_REF IS NULL
	BEGIN

		INSERT INTO #ULT_ENT (CD_FILIAL,CD_PROD,DT_EST,QT_DIAS)
		SELECT 
			A.CD_FILIAL,
			A.CD_PROD,
			GETDATE() DT_EST,
			QTDE_DIAS_SLD_QT_EST + 1
		FROM 
			EST_PROD_CPL A 
		WHERE
			A.CD_EMP=@CD_EMP
			AND A.CD_FILIAL=@CD_FILIAL 
			AND A.QT_EST>0 
	END

	UPDATE C
	SET
		QTDE_DIAS_SLD_QT_EST =U.QT_DIAS 
	FROM 
		EST_PROD_CPL C 
		INNER JOIN #ULT_ENT U ON 
		C.CD_PROD = U.CD_PROD AND
		C.CD_FILIAL = U.CD_FILIAL
	WHERE
		C.CD_EMP=@CD_EMP
		AND U.CD_FILIAL=@CD_FILIAL 
		AND C.QTDE_DIAS_SLD_QT_EST<>U.QT_DIAS;

	UPDATE C
	SET
		QTDE_DIAS_SLD_QT_EST =0
	FROM 
		EST_PROD_CPL C 
	WHERE
		C.CD_EMP=@CD_EMP
		AND C.CD_FILIAL=@CD_FILIAL 
		AND C.QT_EST<=0;


	 
/*******************************************************************************/
	DROP TABLE #ULT_ENT  
	DROP TABLE #RS_ULT_ZERO  
/*******************************************************************************/
